;----------------------------------------------------------------------------
; Nintendo Virtual Boy
; Mednafen 0.9.15
; by BBB
; 1.1
;
; Notes:
; Below are some basic params you can change, there are many other params
; located in the mednafen documentation that you can add if needed.
;
; Some people experience screen flickering and mednafen will not stay in 
; fullscreen, you can changed vDriver below to -vdriver sdl and it will
; possibly fix the issue.
;
; There is no error checking if mednafen fails, so if you try to launch
; your game and nothing happens, then check the stdout.txt in your mednafen
; installation directory to see what went wrong.
;
; To remap your keys, start a game then press alt + shift + 1 to enter
; the key configuration.  Also see mednafen.cfg to change other keys such
; as the exit key.
;
; For Virtual Boy you might not be able to get in game and get stuck
; on the intro screen, so open your cfg file and change these settings
; to allow you to play. There are some extra options here to.
;
; vb.anaglyph.lcolor 0xFF0000
; vb.anaglyph.preset disabled
; vb.anaglyph.rcolor 0x000000
; vb.default_color 0xFFFFFF
; vb.disable_parallax 0
; vb.input.builtin.gamepad.a keyboard 109
; vb.input.builtin.gamepad.b keyboard 110
; vb.input.builtin.gamepad.down-l keyboard 100
; vb.input.builtin.gamepad.down-r keyboard 107
; vb.input.builtin.gamepad.left-l keyboard 115
; vb.input.builtin.gamepad.left-r keyboard 106
; vb.input.builtin.gamepad.lt keyboard 103
; vb.input.builtin.gamepad.rapid_a keyboard 46
; vb.input.builtin.gamepad.rapid_b keyboard 44
; vb.input.builtin.gamepad.right-l keyboard 102
; vb.input.builtin.gamepad.right-r keyboard 108
; vb.input.builtin.gamepad.rt keyboard 104
; vb.input.builtin.gamepad.select keyboard 118
; vb.input.builtin.gamepad.start keyboard 13
; vb.input.builtin.gamepad.up-l keyboard 101
; vb.input.builtin.gamepad.up-r keyboard 105
; 
;----------------------------------------------------------------------------

;Params
fullScreen := "-fs 1" ; 0 or 1
stretchFullscreen := "-vb.stretch 1" ; 0 or 1
vDriver := "-vdriver opengl" ; opengl or sdl
xRes := "-vb.xres 800"
yRes := "-vb.yres 600"
                   
params = %fullScreen% %stretchFullscreen% %vDriver% %xRes% %yRes% 

Run, "%EmuPath%%Executable%" %params% "%romPath%%romName%%romExtension%"

Process, WaitClose, %Executable%
     
ExitApp
           
CloseProcess:
return